<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php'; // Include your database connection file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['caption']) && isset($_FILES['image'])) {
        $caption = $_POST['caption'];
        $image = $_FILES['image'];

        // Directory to upload images
        $target_dir = "../uploads/";
        $target_file = $target_dir . basename($image["name"]);

        // Check if image file is a actual image or fake image
        $check = getimagesize($image["tmp_name"]);
        if ($check === false) {
            echo json_encode(array("error" => "File is not an image."));
            exit;
        }

        // Check if file already exists
        if (file_exists($target_file)) {
            echo json_encode(array("error" => "Sorry, file already exists."));
            exit;
        }

        // Check file size (5MB maximum)
        if ($image["size"] > 5000000) {
            echo json_encode(array("error" => "Sorry, your file is too large."));
            exit;
        }

        // Allow certain file formats
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        if (!in_array($imageFileType, ['jpg', 'png', 'jpeg', 'gif'])) {
            echo json_encode(array("error" => "Sorry, only JPG, JPEG, PNG & GIF files are allowed."));
            exit;
        }

        // If everything is ok, try to upload file
        if (move_uploaded_file($image["tmp_name"], $target_file)) {
            // Store the file path without the "../" prefix
            $image_url = "uploads/" . basename($image["name"]);

            $sql = "INSERT INTO food_slider (caption, image_url) VALUES (?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('ss', $caption, $image_url);

            if ($stmt->execute()) {
                echo json_encode(array("message" => "Food slider added successfully"));
            } else {
                echo json_encode(array("error" => "Error adding food slider: " . $conn->error));
            }

            $stmt->close();
        } else {
            echo json_encode(array("error" => "Sorry, there was an error uploading your file."));
        }
    } else {
        echo json_encode(array("error" => "Invalid input"));
    }
} else {
    echo json_encode(array("error" => "Invalid request method"));
}

$conn->close();
?>
