<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db.php';

// Fetch the last checked order ID
$query = "SELECT last_checked_order_id FROM order_check WHERE id = 1";
$result = mysqli_query($conn, $query);

if (!$result) {
    echo json_encode(['status' => 'error', 'message' => 'Error fetching last order ID: ' . mysqli_error($conn)]);
    exit;
}

$row = mysqli_fetch_assoc($result);
$lastOrderId = $row['last_checked_order_id'];

// Fetch new orders based on the last checked order ID
$query = "SELECT * FROM orders_new_app WHERE id > $lastOrderId ORDER BY id DESC";
$result = mysqli_query($conn, $query);

if (!$result) {
    echo json_encode(['status' => 'error', 'message' => 'Error fetching new orders: ' . mysqli_error($conn)]);
    exit;
}

$newOrders = [];
while ($row = mysqli_fetch_assoc($result)) {
    $newOrders[] = $row;
}

// If there are new orders, update the last checked order ID
if (!empty($newOrders)) {
    $newLastOrderId = $newOrders[0]['id'];
    $query = "UPDATE order_check SET last_checked_order_id = $newLastOrderId WHERE id = 1";
    if (!mysqli_query($conn, $query)) {
        echo json_encode(['status' => 'error', 'message' => 'Error updating last order ID: ' . mysqli_error($conn)]);
        exit;
    }
}

echo json_encode(['status' => 'success', 'newOrders' => $newOrders]);

mysqli_close($conn);
?>
