<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php'; // Include your database connection file

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $response = [];

    // Fetch orders data
    $orders_sql = "SELECT `id`, `store_id`, `cart_items`, `delivery_charge`, `delivery_location_lat`, `delivery_location_lng`, `store_location_lat`, `store_location_lng`, `selected_date`, `payment_method`, `created_at`, `order_status`, `asigned_delivery_rider`, `user_id`, `totalCharge` FROM `orders_new_app`";
    $orders_result = $conn->query($orders_sql);
    $orders_data = [];
    if ($orders_result) {
        if ($orders_result->num_rows > 0) {
            while ($row = $orders_result->fetch_assoc()) {
                $orders_data[] = $row;
            }
        }
    } else {
        echo json_encode(array("error" => "Error fetching orders data: " . $conn->error));
        $conn->close();
        exit;
    }
    $response['orders'] = $orders_data;

    // Fetch users data
    $users_sql = "SELECT `id`, `name`, `phone`, `whatsapp`, `address`, `email`, `password`, `reg_date`, `remember_me_token`, `profile_photo`, `last_activity`, `referral_code`, `refered_code`, `earned` FROM `Users`";
    $users_result = $conn->query($users_sql);
    $users_data = [];
    if ($users_result) {
        if ($users_result->num_rows > 0) {
            while ($row = $users_result->fetch_assoc()) {
                $users_data[] = $row;
            }
        }
    } else {
        echo json_encode(array("error" => "Error fetching users data: " . $conn->error));
        $conn->close();
        exit;
    }
    $response['users'] = $users_data;

    // Fetch stores data
    $stores_sql = "SELECT `id`, `name`, `address`, `contact_number`, `featured_image`, `logo`, `reviews`, `username`, `email`, `phone_number`, `password`, `avl`, `hours`, `visible`, `start_time`, `end_time`, `slot`, `aprove`, `offer`, `p_option`, `service`, `location`, `rating` FROM `Stores`";
    $stores_result = $conn->query($stores_sql);
    $stores_data = [];
    if ($stores_result) {
        if ($stores_result->num_rows > 0) {
            while ($row = $stores_result->fetch_assoc()) {
                $stores_data[] = $row;
            }
        }
    } else {
        echo json_encode(array("error" => "Error fetching stores data: " . $conn->error));
        $conn->close();
        exit;
    }
    $response['stores'] = $stores_data;

    echo json_encode($response);
} else {
    echo json_encode(array("error" => "Invalid request method"));
}

$conn->close();
?>
