<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db.php';

$query = "SELECT id, name FROM Stores";
$result = mysqli_query($conn, $query);

if (!$result) {
    echo json_encode(['status' => 'error', 'message' => 'Error fetching stores: ' . mysqli_error($conn)]);
    exit;
}

$stores = [];
while ($row = mysqli_fetch_assoc($result)) {
    $stores[] = $row;
}

echo json_encode(['status' => 'success', 'stores' => $stores]);

mysqli_close($conn);
?>
