<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

include 'db.php'; // Include your database connection file

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['rider_id'])) {
    $rider_id = intval($_GET['rider_id']);

    $sql = "SELECT o.*, u.*, s.*, u.name as user_name
            FROM orders_new_app o
            JOIN Users u ON o.user_id = u.id
            JOIN Stores s ON o.store_id = s.id
            WHERE o.asigned_delivery_rider = ? AND o.order_status != 'Cancelled'
            ORDER BY o.id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $orders = array();
    while ($row = $result->fetch_assoc()) {
        $orders[] = $row;
    }

    echo json_encode($orders);

    $stmt->close();
} else {
    echo json_encode(array("error" => "Invalid request"));
}

$conn->close();
?>
