<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['rider_id'])) {
    $rider_id = $_GET['rider_id'];

    $sql = "SELECT o.*, 
                   u.name as customer_name, u.phone as customer_phone, u.email as customer_email, u.address as customer_address,
                   s.name as store_name, s.phone_number as store_phone, s.address as store_address
            FROM orders_new_app o
            JOIN Users u ON o.user_id = u.id
            JOIN Stores s ON o.store_id = s.id
            WHERE o.asigned_delivery_rider = ? order by o.id DESC";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $orders = array();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
    }

    echo json_encode($orders);

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array("message" => "Invalid request"));
}
?>
