<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];

    $sql = "SELECT o.*, 
                   u.name as customer_name, u.phone as customer_phone, u.email as customer_email, u.address as customer_address,
                   s.name as store_name, s.phone_number as store_phone, s.address as store_address
            FROM orders_new_app o
            JOIN Users u ON o.user_id = u.id
            JOIN Stores s ON o.store_id = s.id
            WHERE o.id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $order_details = $result->fetch_assoc();
        echo json_encode($order_details);
    } else {
        echo json_encode(array("message" => "No order found with the given ID"));
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array("message" => "Invalid request"));
}
?>
