
<?php


include 'db.php';

if (isset($_GET['rider_id'])) {
    $rider_id = $_GET['rider_id'];

    $sql = "SELECT * FROM delivery_riders WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $profile = $result->fetch_assoc();
        echo json_encode($profile);
    } else {
        echo json_encode(array("message" => "No profile found with the given ID"));
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array("message" => "Invalid request"));
}
?>
