<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

if (isset($_GET['rider_id'])) {
    $rider_id = $_GET['rider_id'];

    $query = "SELECT name, active FROM delivery_riders WHERE id = ?";
    $stmt = $conn->prepare($query);

    if ($stmt === false) {
        echo json_encode(array("error" => "MySQL prepare statement error: " . $conn->error));
        exit;
    }

    $stmt->bind_param('i', $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode(array("error" => "Rider not found"));
    }

    $stmt->close();
} else {
    echo json_encode(array("error" => "Rider ID not provided"));
}

$conn->close();
?>
