<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['rider_id'])) {
    $rider_id = $data['rider_id'];

    $query = "SELECT AVG(rating) as average_rating FROM feedback WHERE rider_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    if ($row) {
        echo json_encode(array("average_rating" => round($row['average_rating'], 2)));
    } else {
        echo json_encode(array("error" => "No ratings found"));
    }

    $stmt->close();
} else {
    echo json_encode(array("error" => "Invalid input"));
}

$conn->close();
?>
