<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

// Function to get rider statistics
function getRiderStats($conn, $rider_id) {
    $stats = array(
        "totalDeliveries" => 0,
        "pendingDeliveries" => 0,
        "completedDeliveries" => 0
    );

    // Query for total deliveries
    $query = "SELECT COUNT(*) as total FROM orders_new_app WHERE asigned_delivery_rider = ?";
    $stmt = $conn->prepare($query);
    if ($stmt) {
        $stmt->bind_param('i', $rider_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $row = $result->fetch_assoc()) {
            $stats['totalDeliveries'] = $row['total'];
        }
        $stmt->close();
    } else {
        throw new Exception("Failed to prepare statement: " . $conn->error);
    }

    // Query for pending deliveries
    $query = "SELECT COUNT(*) as pending FROM orders_new_app WHERE order_status = 'Pending' AND asigned_delivery_rider = ?";
    $stmt = $conn->prepare($query);
    if ($stmt) {
        $stmt->bind_param('i', $rider_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $row = $result->fetch_assoc()) {
            $stats['pendingDeliveries'] = $row['pending'];
        }
        $stmt->close();
    } else {
        throw new Exception("Failed to prepare statement: " . $conn->error);
    }

    // Query for completed deliveries
    $query = "SELECT COUNT(*) as completed FROM orders_new_app WHERE order_status = 'Completed' AND asigned_delivery_rider = ?";
    $stmt = $conn->prepare($query);
    if ($stmt) {
        $stmt->bind_param('i', $rider_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $row = $result->fetch_assoc()) {
            $stats['completedDeliveries'] = $row['completed'];
        }
        $stmt->close();
    } else {
        throw new Exception("Failed to prepare statement: " . $conn->error);
    }

    return $stats;
}

try {
    if (isset($_GET['rider_id'])) {
        $rider_id = $_GET['rider_id'];
        $stats = getRiderStats($conn, $rider_id);
        echo json_encode($stats);
    } else {
        echo json_encode(array("error" => "Rider ID not provided"));
    }
} catch (Exception $e) {
    echo json_encode(array("error" => $e->getMessage()));
}

$conn->close();
?>
