<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

if (isset($_GET['rider_id'])) {
    $rider_id = $_GET['rider_id'];

    $query = "SELECT active FROM delivery_riders WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode($row);
    } else {
        echo json_encode(array("error" => "Rider not found"));
    }

    $stmt->close();
} else {
    echo json_encode(array("error" => "Rider ID not provided"));
}

$conn->close();
?>
