<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db.php';

$data = json_decode(file_get_contents('php://input'), true);

$username = $data['username'];
$password = $data['password'];
$userType = $data['userType'];

if ($userType == 'admin') {
    $query = "SELECT id, username, password, area FROM admins WHERE username = ?";
} else {
    $query = "SELECT id, email AS username, password, 'all' AS area FROM delivery_riders WHERE email = ?";
}

$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if ($user && password_verify($password, $user['password'])) {
    echo json_encode([
        'success' => true,
        'user' => [
            'id' => $user['id'],
            'area' => $user['area']
        ]
    ]);
} else {
    echo json_encode(['success' => false]);
}

$stmt->close();
$conn->close();
?>
