<?php

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, access");
header("Access-Control-Allow-Credentials: true");

include 'db.php';

$action = $_GET['action'];

if ($action == 'fetch_stores') {
    $sql = "SELECT * FROM Stores";
    $result = $conn->query($sql);

    $stores = array();
    while ($row = $result->fetch_assoc()) {
        $stores[] = $row;
    }

    echo json_encode($stores);
} elseif ($action == 'fetch_foods') {
    $store_id = intval($_GET['store_id']);
    $sql = "SELECT * FROM Foods1 WHERE store_id = $store_id";
    $result = $conn->query($sql);

    $foods = array();
    while ($row = $result->fetch_assoc()) {
        $foods[] = $row;
    }

    echo json_encode($foods);
} elseif ($action == 'fetch_food_details') {
    $food_id = intval($_GET['food_id']);
    $sql = "SELECT * FROM Foods1 WHERE id = $food_id";
    $result = $conn->query($sql);

    $food = array();
    if ($row = $result->fetch_assoc()) {
        $food = $row;
        $sql = "SELECT * FROM Sizes WHERE food_id = $food_id";
        $result_sizes = $conn->query($sql);
        $sizes = array();
        while ($size = $result_sizes->fetch_assoc()) {
            $sizes[] = $size;
        }
        $food['sizes'] = $sizes;

        $sql = "SELECT * FROM Options WHERE food_id = $food_id";
        $result_options = $conn->query($sql);
        $options = array();
        while ($option = $result_options->fetch_assoc()) {
            $options[] = $option;
        }
        $food['options'] = $options;
    }

    echo json_encode($food);
} elseif ($action == 'fetch_categories') {
    $sql = "SELECT * FROM categories";
    $result = $conn->query($sql);

    $categories = array();
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }

    echo json_encode($categories);
} elseif ($action == 'fetch_category') {
    $food_id = intval($_GET['food_id']);
    $sql = "SELECT c.* FROM categories c
            JOIN Foods1 f ON f.category_id = c.id
            WHERE f.id = $food_id";
    $result = $conn->query($sql);

    if ($row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode(["error" => "Category not found"]);
    }
} elseif ($action == 'update_food') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!empty($data['id']) && !empty($data['title']) && !empty($data['base_price']) && !empty($data['quantity']) && !empty($data['des']) && !empty($data['category_id']) && !empty($data['stock']) && !empty($data['foodtime'])) {
        $id = intval($data['id']);
        $title = $conn->real_escape_string($data['title']);
        $base_price = floatval($data['base_price']);
        $quantity = intval($data['quantity']);
        $des = $conn->real_escape_string($data['des']);
        $category_id = intval($data['category_id']);
        $stock = intval($data['stock']);
        $foodtime = $conn->real_escape_string($data['foodtime']);

        $sql = "UPDATE Foods1 SET 
                title='$title', 
                base_price='$base_price', 
                quantity='$quantity', 
                des='$des', 
                category_id='$category_id', 
                stock='$stock', 
                foodtime='$foodtime' 
                WHERE id='$id'";

        if ($conn->query($sql) === TRUE) {
            $sizes = !empty($data['sizes']) ? $data['sizes'] : [['size' => '', 'size_price' => 0]];
            $options = !empty($data['options']) ? $data['options'] : [['custom_option' => '', 'option_price' => 0]];

            foreach ($sizes as $size) {
                if (isset($size['id'])) {
                    $sql = "UPDATE Sizes SET size='{$size['size']}', size_price='{$size['size_price']}' WHERE id='{$size['id']}'";
                } else {
                    $sql = "INSERT INTO Sizes (food_id, size, size_price) VALUES ('$id', '{$size['size']}', '{$size['size_price']}')";
                }
                $conn->query($sql);
            }

            foreach ($options as $option) {
                if (isset($option['id'])) {
                    $sql = "UPDATE Options SET custom_option='{$option['custom_option']}', option_price='{$option['option_price']}' WHERE id='{$option['id']}'";
                } else {
                    $sql = "INSERT INTO Options (food_id, custom_option, option_price) VALUES ('$id', '{$option['custom_option']}', '{$option['option_price']}')";
                }
                $conn->query($sql);
            }

            echo json_encode(["message" => "Record updated successfully"]);
        } else {
            echo json_encode(["error" => "Error updating record: " . $conn->error]);
        }
    } else {
        echo json_encode(["error" => "Invalid input data"]);
    }
} elseif ($action == 'upload_image') {
    $food_id = intval($_POST['food_id']);
    $target_dir = "../uploads/";
    $target_file = $target_dir . basename($_FILES["image"]["name"]);
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    $check = getimagesize($_FILES["image"]["tmp_name"]);
    if ($check !== false) {
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $relative_path = "uploads/" . basename($_FILES["image"]["name"]);
            $sql = "UPDATE Foods1 SET featured_image='$relative_path' WHERE id='$food_id'";
            if ($conn->query($sql) === TRUE) {
                echo json_encode(["message" => "Image uploaded successfully"]);
            } else {
                echo json_encode(["error" => "Error updating record: " . $conn->error]);
            }
        } else {
            echo json_encode(["error" => "Sorry, there was an error uploading your file."]);
        }
    } else {
        echo json_encode(["error" => "File is not an image."]);
    }
} elseif ($action == 'upload_gallery') {
    $food_id = intval($_POST['food_id']);
    $target_dir = "../uploads/";
    $target_file = $target_dir . basename($_FILES["gallery"]["name"]);
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    $check = getimagesize($_FILES["gallery"]["tmp_name"]);
    if ($check !== false) {
        if (move_uploaded_file($_FILES["gallery"]["tmp_name"], $target_file)) {
            $relative_path = "../uploads/" . basename($_FILES["gallery"]["name"]);
            $sql = "UPDATE Foods1 SET gallery_images='$relative_path' WHERE id='$food_id'";
            if ($conn->query($sql) === TRUE) {
                echo json_encode(["message" => "Gallery image uploaded successfully"]);
            } else {
                echo json_encode(["error" => "Error updating record: " . $conn->error]);
            }
        } else {
            echo json_encode(["error" => "Sorry, there was an error uploading your file."]);
        }
    } else {
        echo json_encode(["error" => "File is not an image."]);
    }
} elseif ($action == 'delete_food') {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = intval($data['id']);

    $sql = "DELETE FROM Foods1 WHERE id = '$id'";
    if ($conn->query($sql) === TRUE) {
        echo json_encode(["message" => "Food deleted successfully"]);
    } else {
        echo json_encode(["error" => "Error deleting food: " . $conn->error]);
    }
} elseif ($action == 'add_food') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!empty($data['store_id']) && !empty($data['title']) && !empty($data['base_price']) && !empty($data['quantity']) && !empty($data['des']) && !empty($data['category_id']) && !empty($data['stock']) && !empty($data['foodtime'])) {
        $store_id = intval($data['store_id']);
        $title = $conn->real_escape_string($data['title']);
        $base_price = floatval($data['base_price']);
        $quantity = intval($data['quantity']);
        $des = $conn->real_escape_string($data['des']);
        $category_id = intval($data['category_id']);
        $stock = intval($data['stock']);
        $foodtime = $conn->real_escape_string($data['foodtime']);

        $sql = "INSERT INTO Foods1 (store_id, title, base_price, quantity, des, category_id, stock, foodtime) 
                VALUES ('$store_id', '$title', '$base_price', '$quantity', '$des', '$category_id', '$stock', '$foodtime')";

        if ($conn->query($sql) === TRUE) {
            $food_id = $conn->insert_id;

            $sizes = !empty($data['sizes']) ? $data['sizes'] : [['size' => '', 'size_price' => 0]];
            $options = !empty($data['options']) ? $data['options'] : [['custom_option' => '', 'option_price' => 0]];

            foreach ($sizes as $size) {
                $sql = "INSERT INTO Sizes (food_id, size, size_price) VALUES ('$food_id', '{$size['size']}', '{$size['size_price']}')";
                $conn->query($sql);
            }

            foreach ($options as $option) {
                $sql = "INSERT INTO Options (food_id, custom_option, option_price) VALUES ('$food_id', '{$option['custom_option']}', '{$option['option_price']}')";
                $conn->query($sql);
            }

            if (!empty($_FILES['featured_image']['name'])) {
                $target_file = $target_dir . basename($_FILES["featured_image"]["name"]);
                if (move_uploaded_file($_FILES["featured_image"]["tmp_name"], $target_file)) {
                    $relative_path = "../uploads/" . basename($_FILES["featured_image"]["name"]);
                    $sql = "UPDATE Foods1 SET featured_image='$relative_path' WHERE id='$food_id'";
                    $conn->query($sql);
                }
            }

            if (!empty($_FILES['gallery_image']['name'])) {
                $target_file = $target_dir . basename($_FILES["gallery_image"]["name"]);
                if (move_uploaded_file($_FILES["gallery_image"]["tmp_name"], $target_file)) {
                    $relative_path = "../uploads/" . basename($_FILES["gallery_image"]["name"]);
                    $sql = "UPDATE Foods1 SET gallery_images='$relative_path' WHERE id='$food_id'";
                    $conn->query($sql);
                }
            }

            echo json_encode(["message" => "New food added successfully", "food_id" => $food_id]);
        } else {
            echo json_encode(["error" => "Error adding new food: " . $conn->error]);
        }
    } else {
        echo json_encode(["error" => "Invalid input data"]);
    }
}

$conn->close();
?>
