<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, access");
header("Access-Control-Allow-Credentials: true");
include 'db.php';

$action = $_GET['action'];

switch ($action) {
    case 'fetch_order':
        fetchOrder();
        break;
    case 'fetch_foods':
        fetchFoods();
        break;
    case 'fetch_category':
        fetchCategory();
        break;
    case 'fetch_sizes':
        fetchSizes();
        break;
    case 'fetch_options':
        fetchOptions();
        break;
    case 'update_order':
        updateOrder();
        break;
    default:
        echo json_encode(['error' => 'Invalid action']);
}

function fetchOrder() {
    global $conn;
    $orderId = $_GET['order_id'];
    $query = "SELECT * FROM orders_new_app WHERE id = $orderId";
    $result = mysqli_query($conn, $query);
    if ($result) {
        $order = mysqli_fetch_assoc($result);
        echo json_encode($order);
    } else {
        echo json_encode(['error' => 'Failed to fetch order']);
    }
}

function fetchFoods() {
    global $conn;
    $storeId = $_GET['store_id'];
    $query = "SELECT * FROM Foods WHERE store_id = $storeId";
    $result = mysqli_query($conn, $query);
    if ($result) {
        $foods = mysqli_fetch_all($result, MYSQLI_ASSOC);
        echo json_encode($foods);
    } else {
        echo json_encode(['error' => 'Failed to fetch foods']);
    }
}

function fetchCategory() {
    global $conn;
    $foodId = $_GET['food_id'];
    $query = "SELECT categories.title FROM categories
              JOIN Foods1 ON foods.category_id = categories.id
              WHERE Foods1.id = $foodId";
    $result = mysqli_query($conn, $query);
    if ($result) {
        $category = mysqli_fetch_assoc($result);
        echo json_encode($category);
    } else {
        echo json_encode(['error' => 'Failed to fetch category']);
    }
}

function fetchSizes() {
    global $conn;
    $foodId = $_GET['food_id'];
    $query = "SELECT * FROM Sizes WHERE food_id = $foodId";
    $result = mysqli_query($conn, $query);
    if ($result) {
        $sizes = mysqli_fetch_all($result, MYSQLI_ASSOC);
        echo json_encode($sizes);
    } else {
        echo json_encode(['error' => 'Failed to fetch sizes']);
    }
}

function fetchOptions() {
    global $conn;
    $foodId = $_GET['food_id'];
    $query = "SELECT * FROM Options WHERE food_id = $foodId";
    $result = mysqli_query($conn, $query);
    if ($result) {
        $options = mysqli_fetch_all($result, MYSQLI_ASSOC);
        echo json_encode($options);
    } else {
        echo json_encode(['error' => 'Failed to fetch options']);
    }
}

function updateOrder() {
    global $conn;
    $data = json_decode(file_get_contents('php://input'), true);
    $orderId = $data['id'];
    $cartItems = $data['cart_items'];
    $totalCharge = $data['totalCharge'];
    // Add other fields as needed

    $query = "UPDATE orders_new_app SET cart_items = '$cartItems', totalCharge = $totalCharge WHERE id = $orderId";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => 'Order updated successfully']);
    } else {
        echo json_encode(['error' => 'Failed to update order']);
    }
}

?>
