<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

include 'db.php';

// Get the action, order_id, or store_id from the request
$action = isset($_GET['action']) ? $_GET['action'] : (isset($_POST['action']) ? $_POST['action'] : null);
$order_id = isset($_GET['order_id']) ? mysqli_real_escape_string($conn, $_GET['order_id']) : (isset($_POST['order_id']) ? mysqli_real_escape_string($conn, $_POST['order_id']) : null);
$store_id = isset($_GET['store_id']) ? mysqli_real_escape_string($conn, $_GET['store_id']) : (isset($_POST['store_id']) ? mysqli_real_escape_string($conn, $_POST['store_id']) : null);

// Ensure the action is provided
if (!$action) {
    echo json_encode(['error' => 'Action is required']);
    exit;
}

// Fetch store_id from the request and retrieve foods
if ($action == 'fetch_foods') {
    if (!$store_id) {
        echo json_encode(['error' => 'Store ID is required']);
        exit;
    }

    // Fetch foods for the given store_id
    $query = "SELECT * FROM Foods1 WHERE store_id = '$store_id'";
    $result = mysqli_query($conn, $query);

    if ($result) {
        $foods = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $food_id = $row['id'];

            // Fetch sizes for each food
            $sizesQuery = "SELECT * FROM Sizes WHERE food_id = '$food_id'";
            $sizesResult = mysqli_query($conn, $sizesQuery);
            $sizes = mysqli_fetch_all($sizesResult, MYSQLI_ASSOC);

            // Fetch custom options for each food
            $optionsQuery = "SELECT * FROM Options WHERE food_id = '$food_id'";
            $optionsResult = mysqli_query($conn, $optionsQuery);
            $options = mysqli_fetch_all($optionsResult, MYSQLI_ASSOC);

            // Add sizes and custom options to the food item
            $row['sizes'] = $sizes;
            $row['customOptions'] = $options;
            $foods[] = $row;
        }
        echo json_encode($foods);
    } else {
        echo json_encode(['error' => 'Failed to fetch foods for store']);
    }

// Fetch an order's cart items
} elseif ($action == 'fetch') {
    if (!$order_id) {
        echo json_encode(['error' => 'Order ID is required']);
        exit;
    }

    // Fetch cart items from the orders table
    $orderQuery = "SELECT cart_items FROM orders_new_app WHERE id = '$order_id'";
    $orderResult = mysqli_query($conn, $orderQuery);

    if ($orderResult && mysqli_num_rows($orderResult) > 0) {
        $orderRow = mysqli_fetch_assoc($orderResult);
        $cart_items = json_decode($orderRow['cart_items'], true);
        echo json_encode($cart_items);
    } else {
        echo json_encode(['error' => 'Order not found']);
    }

// Update order cart items and total charge
} elseif ($action == 'update') {
    if (!$order_id || !isset($_POST['cart_items']) || !isset($_POST['totalCharge'])) {
        echo json_encode(['error' => 'Order ID, cart items, and total charge are required']);
        exit;
    }

    // Update the order with the new cart items and total charge
    $updated_cart_items = mysqli_real_escape_string($conn, $_POST['cart_items']);
    $total_charge = mysqli_real_escape_string($conn, $_POST['totalCharge']);

    $query = "UPDATE orders_new_app SET cart_items = '$updated_cart_items', totalCharge = '$total_charge' WHERE id = '$order_id'";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => 'Order updated successfully']);
    } else {
        echo json_encode(['error' => 'Failed to update order']);
    }
} else {
    echo json_encode(['error' => 'Invalid action']);
}

mysqli_close($conn);
?>
