<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

// Function to calculate the distance between two coordinates
function calculateDistance($lat1, $lon1, $lat2, $lon2) {
    $R = 6371; // Radius of the Earth in km
    $dLat = ($lat2 - $lat1) * (M_PI / 180);
    $dLon = ($lon2 - $lon1) * (M_PI / 180);
    $a = sin($dLat / 2) * sin($dLat / 2) +
        cos($lat1 * (M_PI / 180)) * cos($lat2 * (M_PI / 180)) *
        sin($dLon / 2) * sin($dLon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance = $R * $c;
    return $distance;
}

function getOrders($conn, $rider_id, $rider_lat, $rider_lon) {
    $orders = array();

    $query = "SELECT o.*, o.id, u.name as customer_name, o.created_at as order_date,o.asigned_delivery_rider, o.order_status as status, o.totalCharge as total, o.delivery_location_lat as delivery_latitude, o.delivery_location_lng as delivery_longitude, o.cart_items, s.name as store_name, s.address as store_address
              FROM orders_new_app o
              JOIN Users u ON o.user_id = u.id
              JOIN Stores s ON o.store_id = s.id
              WHERE (o.asigned_delivery_rider = ? OR o.asigned_delivery_rider IS NULL) order by id DESC";
    $stmt = $conn->prepare($query);

    if ($stmt === false) {
        throw new Exception('MySQL prepare statement error: ' . $conn->error);
    }

    $stmt->bind_param('i', $rider_id);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        // Extracting store latitude and longitude from the address column
        $store_location = explode(',', $row['store_address']);
        $store_latitude = floatval(trim($store_location[0]));
        $store_longitude = floatval(trim($store_location[1]));

        $distance = calculateDistance($rider_lat, $rider_lon, $row['delivery_latitude'], $row['delivery_longitude']);
        // if ($distance <= 2000) { // 20 km radius
            $row['store_latitude'] = $store_latitude;
            $row['store_longitude'] = $store_longitude;
            $orders[] = $row;
        // }
    }

    return $orders;
}

try {
    if (isset($_GET['rider_id']) && isset($_GET['latitude']) && isset($_GET['longitude'])) {
        $rider_id = $_GET['rider_id'];
        $rider_lat = $_GET['latitude'];
        $rider_lon = $_GET['longitude'];
        $orders = getOrders($conn, $rider_id, $rider_lat, $rider_lon);
        echo json_encode($orders);
    } else {
        echo json_encode(array("error" => "Rider ID, latitude, and longitude not provided"));
    }
} catch (Exception $e) {
    echo json_encode(array("error" => $e->getMessage()));
}

$conn->close();
?>
