<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db.php';

// Fetch total revenue
$totalRevenueQuery = "SELECT SUM(totalCharge) as totalRevenue FROM orders_new_app";
$totalRevenueResult = mysqli_query($conn, $totalRevenueQuery);
$totalRevenueRow = mysqli_fetch_assoc($totalRevenueResult);
$totalRevenue = $totalRevenueRow['totalRevenue'];

// Fetch monthly revenue
$monthlyRevenueQuery = "SELECT DATE_FORMAT(created_at, '%m') as month, SUM(totalCharge) as revenue FROM orders_new_app GROUP BY month";
$monthlyRevenueResult = mysqli_query($conn, $monthlyRevenueQuery);

$monthlyRevenue = [];
while ($row = mysqli_fetch_assoc($monthlyRevenueResult)) {
    $monthlyRevenue[] = ['month' => $row['month'], 'revenue' => $row['revenue']];
}

$response = [
    'totalRevenue' => $totalRevenue,
    'monthlyRevenue' => $monthlyRevenue,
];

if (isset($_GET['month'])) {
    $month = $_GET['month'];
    $monthRevenueQuery = "SELECT SUM(totalCharge) as monthRevenue FROM orders_new_app WHERE DATE_FORMAT(created_at, '%m') = '$month'";
    $monthRevenueResult = mysqli_query($conn, $monthRevenueQuery);
    $monthRevenueRow = mysqli_fetch_assoc($monthRevenueResult);
    $response['monthRevenue'] = $monthRevenueRow['monthRevenue'];
}

echo json_encode($response);

mysqli_close($conn);
