<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

$data = json_decode(file_get_contents("php://input"), true);
$phone = $data['phone'];
$password = $data['password'];

$response = array("success" => false);

if (!empty($phone) && !empty($password)) {
    $query = "SELECT id, name, password FROM delivery_riders WHERE phone = ? ";
    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $stmt->bind_result($id, $name, $hashed_password);
            $stmt->fetch();
            
            if (password_verify($password, $hashed_password)) {
                $response['success'] = true;
                $response['rider'] = array(
                    "id" => $id,
                    "name" => $name
                );
            }
        }
        
        $stmt->close();
    }
}

echo json_encode($response);
$conn->close();
?>
