<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

switch ($method) {
    case 'GET':
        handleGet($action, $conn);
        break;
    case 'POST':
        handlePost($action, $conn);
        break;
    default:
        echo json_encode(array("error" => "Invalid request method"));
        break;
}

mysqli_close($conn);

function handleGet($action, $conn) {
    switch ($action) {
        case 'fetch_riders':
            fetchRiders($conn);
            break;
        case 'fetch_rider_details':
            fetchRiderDetails($conn);
            break;
        default:
            echo json_encode(array("error" => "Invalid GET action"));
            break;
    }
}

function handlePost($action, $conn) {
    switch ($action) {
        case 'approve_rider':
            approveRider($conn);
            break;
        case 'add_rider':
            addRider($conn);
            break;
        default:
            echo json_encode(array("error" => "Invalid POST action"));
            break;
    }
}

function fetchRiders($conn) {
    $page = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
    $limit = 10;
    $offset = ($page - 1) * $limit;

    $searchQuery = $search ? "WHERE name LIKE '%$search%' OR email LIKE '%$search%' OR phone LIKE '%$search%'" : '';
    
    $query = "SELECT * FROM delivery_riders $searchQuery LIMIT $limit OFFSET $offset";
    $result = mysqli_query($conn, $query);

    $riders = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $riders[] = $row;
    }

    $countQuery = "SELECT COUNT(*) AS total FROM delivery_riders $searchQuery";
    $countResult = mysqli_query($conn, $countQuery);
    $countRow = mysqli_fetch_assoc($countResult);
    $totalPages = ceil($countRow['total'] / $limit);

    echo json_encode(['riders' => $riders, 'totalPages' => $totalPages]);
}

function fetchRiderDetails($conn) {
    $rider_id = $_GET['rider_id'];
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

    // Fetch rider details
    $rider_query = "SELECT * FROM delivery_riders WHERE id = $rider_id";
    $rider_result = mysqli_query($conn, $rider_query);
    $rider = mysqli_fetch_assoc($rider_result);

    // Fetch rider feedback
    $feedback_query = "SELECT * FROM feedback WHERE rider_id = $rider_id";
    $feedback_result = mysqli_query($conn, $feedback_query);
    $feedback = [];
    while ($row = mysqli_fetch_assoc($feedback_result)) {
        $feedback[] = $row;
    }

    // Fetch rider withdrawals
    $withdrawals_query = "SELECT * FROM riderwidrow WHERE rider_id = $rider_id";
    $withdrawals_result = mysqli_query($conn, $withdrawals_query);
    $withdrawals = [];
    while ($row = mysqli_fetch_assoc($withdrawals_result)) {
        $withdrawals[] = $row;
    }

    // Fetch rider earnings (grouped by Sundays)
    $dateFilter = '';
    if ($start_date && $end_date) {
        $dateFilter = "AND created_at BETWEEN '$start_date' AND '$end_date'";
    }

    $earnings_query = "
        SELECT 
            DATE_FORMAT(created_at, '%Y-%m-%d') AS date,
            SUM(delivery_charge) AS earnings
        FROM 
            orders_new_app 
        WHERE 
            asigned_delivery_rider = $rider_id $dateFilter
        GROUP BY 
            YEARWEEK(created_at, 1)
        ORDER BY 
            created_at DESC
    ";
    $earnings_result = mysqli_query($conn, $earnings_query);
    $earnings = [];
    while ($row = mysqli_fetch_assoc($earnings_result)) {
        $earnings[] = $row;
    }

    echo json_encode([
        'rider' => $rider,
        'feedback' => $feedback,
        'withdrawals' => $withdrawals,
        'earnings' => $earnings,
    ]);
}

function approveRider($conn) {
    $data = json_decode(file_get_contents("php://input"), true);
    $rider_id = $data['rider_id'];
    $status = $data['status'];
    
    if($status==='1'){
        $status === 'approved';
    }
    else{
        $status === 'Pending';
    }

    $query = "UPDATE delivery_riders SET approve_status = $status WHERE id = $rider_id";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
    }
}

function addRider($conn) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $vehicle_number = $_POST['vehicle_number'];
    $nic_number = $_POST['nic_number'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $vehicle_photo = uploadFile('vehicle_photo');
    $profile_image = uploadFile('profile_image');
    $licence_photo = uploadFile('licence_photo');

    $query = "
        INSERT INTO delivery_riders (name, email, phone, address, vehicle_number, nic_number, password, vehicle_photo, profile_image, licence_photo) 
        VALUES ('$name', '$email', '$phone', '$address', '$vehicle_number', '$nic_number', '$password', '$vehicle_photo', '$profile_image', '$licence_photo')
    ";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
    }
}

function uploadFile($field) {
    if (isset($_FILES[$field]) && $_FILES[$field]['error'] == 0) {
        $fileName = time() . '_' . $_FILES[$field]['name'];
        $filePath = 'uploads/' . $fileName;
        if (move_uploaded_file($_FILES[$field]['tmp_name'], $filePath)) {
            return $filePath;
        }
    }
    return null;
}
?>
