<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

function saveFile($file) {
    $target_dir = ",,/uploads/";
    $target_file = $target_dir . basename($file["name"]);
    if (move_uploaded_file($file["tmp_name"], $target_file)) {
        return $target_file;
    }
    return null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $address = $_POST['address'];
    $vehicle_number = $_POST['vehicle_number'];
    $nic_number = $_POST['nic_number'];
    
    $vehicle_photo = isset($_FILES['vehicle_photo']) ? saveFile($_FILES['vehicle_photo'], 'vehicle_photos') : null;
    $profile_image = isset($_FILES['profile_image']) ? saveFile($_FILES['profile_image'], 'profile_images') : null;
    $licence_photo = isset($_FILES['licence_photo']) ? saveFile($_FILES['licence_photo'], 'licence_photos') : null;

    if ($vehicle_photo && $profile_image && $licence_photo) {
        $stmt = $conn->prepare("INSERT INTO delivery_riders (name, email, phone, password, address, vehicle_number, vehicle_photo, profile_image, nic_number, licence_photo, approve_status, active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending', 1)");
        $stmt->bind_param("ssssssssss", $name, $email, $phone, $password, $address, $vehicle_number, $vehicle_photo, $profile_image, $nic_number, $licence_photo);
        
        if ($stmt->execute()) {
            echo json_encode(array("success" => true, "message" => "Registration successful"));
        } else {
            echo json_encode(array("success" => false, "message" => "Registration failed"));
        }
        $stmt->close();
    } else {
        echo json_encode(array("success" => false, "message" => "Failed to upload files"));
    }
} else {
    echo json_encode(array("success" => false, "message" => "Invalid request method"));
}

$conn->close();
?>
