<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

include 'db.php';

// Get the order_id, cart_items, and totalCharge from POST request
$order_id = isset($_POST['order_id']) ? mysqli_real_escape_string($conn, $_POST['order_id']) : null;
$cart_items = isset($_POST['cart_items']) ? $_POST['cart_items'] : null; // Don't escape it yet since it's JSON
$totalCharge = isset($_POST['totalCharge']) ? mysqli_real_escape_string($conn, $_POST['totalCharge']) : null;

// Ensure that order_id, cart_items, and totalCharge are provided
if (!$order_id || !$cart_items || !$totalCharge) {
    echo json_encode(['error' => 'Order ID, cart items, and total charge are required']);
    exit;
}

// Decode cart_items to verify if it's a valid JSON format
$decoded_cart_items = json_decode($cart_items, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['error' => 'Invalid cart items format']);
    exit;
}

// Escape the JSON string for storage
$cart_items = mysqli_real_escape_string($conn, json_encode($decoded_cart_items));

// Fetch the old total charge and user ID from the orders table
$orderQuery = "SELECT totalCharge, user_id, delivery_charge FROM orders_new_app WHERE id = '$order_id'";
$orderResult = mysqli_query($conn, $orderQuery);

if ($orderResult && mysqli_num_rows($orderResult) > 0) {
    $orderRow = mysqli_fetch_assoc($orderResult);
    $old_total_charge = $orderRow['totalCharge'];
    $delivery_charge = $orderRow['delivery_charge'];
    $user_id = $orderRow['user_id'];
    $totalCharge = $totalCharge + $delivery_charge;

    // Update the order with the new cart items and total charge
    $updateQuery = "UPDATE orders_new_app SET cart_items = '$cart_items', totalCharge = '$totalCharge' WHERE id = '$order_id'";
    if (mysqli_query($conn, $updateQuery)) {
        $chargeDifference = $old_total_charge - $totalCharge;

        // Adjust the user's wallet based on the charge difference
        if ($chargeDifference != 0) {
            $walletQuery = "SELECT * FROM Wallet WHERE user_id = '$user_id'";
            $walletResult = mysqli_query($conn, $walletQuery);

            if ($walletResult && mysqli_num_rows($walletResult) > 0) {
                // Update the existing wallet balance
                $walletRow = mysqli_fetch_assoc($walletResult);
                $new_balance = $walletRow['balance'] + $chargeDifference;
                $updateWalletQuery = "UPDATE Wallet SET balance = '$new_balance' WHERE user_id = '$user_id'";
                mysqli_query($conn, $updateWalletQuery);
            } else {
                // Create a new wallet for the user
                $createWalletQuery = "INSERT INTO Wallet (user_id, balance, status) VALUES ('$user_id', '$chargeDifference', 'active')";
                mysqli_query($conn, $createWalletQuery);
            }
        }

        echo json_encode(['success' => 'Order updated and wallet adjusted successfully']);
    } else {
        echo json_encode(['error' => 'Failed to update order']);
    }
} else {
    echo json_encode(['error' => 'Order not found']);
}

mysqli_close($conn);
?>
