<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['rider_id']) && isset($data['latitude']) && isset($data['longitude'])) {
    $rider_id = $data['rider_id'];
    $latitude = $data['latitude'];
    $longitude = $data['longitude'];

    // Check if rider_id already exists
    $checkQuery = "SELECT id FROM rider_location WHERE rider_id = ?";
    $checkStmt = $conn->prepare($checkQuery);
    $checkStmt->bind_param('i', $rider_id);
    $checkStmt->execute();
    $checkResult = $checkStmt->get_result();

    if ($checkResult->num_rows > 0) {
        // Update the existing record
        $updateQuery = "UPDATE rider_location SET current_location_latitude = ?, current_location_longitude = ?, created_at = NOW() WHERE rider_id = ?";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bind_param('ddi', $latitude, $longitude, $rider_id);

        if ($updateStmt->execute()) {
            echo json_encode(array("success" => true, "message" => "Location updated"));
        } else {
            echo json_encode(array("error" => "Failed to update location"));
        }

        $updateStmt->close();
    } else {
        // Insert new record
        $insertQuery = "INSERT INTO rider_location (rider_id, current_location_latitude, current_location_longitude, created_at) VALUES (?, ?, ?, NOW())";
        $insertStmt = $conn->prepare($insertQuery);
        $insertStmt->bind_param('idd', $rider_id, $latitude, $longitude);

        if ($insertStmt->execute()) {
            echo json_encode(array("success" => true, "message" => "Location inserted"));
        } else {
            echo json_encode(array("error" => "Failed to insert location"));
        }

        $insertStmt->close();
    }

    $checkStmt->close();
} else {
    echo json_encode(array("error" => "Invalid input"));
}

$conn->close();
?>
