<?php


include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the input data
    $data = json_decode(file_get_contents("php://input"), true);

    // Validate the input data
    if (isset($data['task_id']) && isset($data['status'])) {
        $task_id = $data['task_id'];
        $status = $data['status'];

        // Update the task status in the database
        $sql = "UPDATE tasks SET status = ?, updated_at = NOW() WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $status, $task_id);

        if ($stmt->execute()) {
            echo json_encode(array("message" => "Task status updated successfully."));
        } else {
            echo json_encode(array("message" => "Error updating task status."));
        }

        $stmt->close();
    } else {
        echo json_encode(array("message" => "Invalid input data."));
    }

    $conn->close();
} else {
    echo json_encode(array("message" => "Invalid request method."));
}
?>
