<?php
header("Access-Control-Allow-Origin:*");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require_once 'db.php';

$action = isset($_GET['action']) ? $_GET['action'] : null;

if ($action) {
    switch ($action) {
        case 'fetch':
            fetchUsers($conn);
            break;
        case 'fetch_riders':
            fetchRiders($conn);
            break;
        case 'fetch_wallets':
            fetchWallets($conn);
            break;
        case 'fetch_admins':
            fetchAdmins($conn);
            break;
        case 'add':
            addUser($conn);
            break;
        case 'add_admin':
            addAdmin($conn);
            break;
        case 'edit_admin':
            editAdmin($conn);
            break;
        case 'delete_admin':
            deleteAdmin($conn);
            break;
        case 'edit_wallet':  // Added case for wallet editing
            editWallet($conn);
            break;
        default:
            echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'No action specified']);
}

mysqli_close($conn);

function fetchUsers($conn) {
    $query = "SELECT id, name, email, phone FROM Users ORDER BY id DESC";
    $result = mysqli_query($conn, $query);

    $users = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $users[] = $row;
    }

    echo json_encode($users);
}

function fetchRiders($conn) {
    $query = "SELECT id, name, email, phone, vehicle_number FROM delivery_riders ORDER BY id DESC";
    $result = mysqli_query($conn, $query);

    $riders = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $riders[] = $row;
    }

    echo json_encode($riders);
}

function fetchWallets($conn) {
    $query = "SELECT id, user_id, balance, status FROM Wallet ORDER BY id DESC";
    $result = mysqli_query($conn, $query);

    $wallets = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $wallets[] = $row;
    }

    echo json_encode($wallets);
}

function fetchAdmins($conn) {
    $query = "SELECT id, full_name, username, email, phone, area FROM admins ORDER BY id DESC";
    $result = mysqli_query($conn, $query);

    $admins = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $admins[] = $row;
    }

    echo json_encode($admins);
}

function addUser($conn) {
    $data = json_decode(file_get_contents('php://input'), true);
    $name = $data['name'];
    $email = $data['email'];
    $phone = $data['phone'];

    $query = $conn->prepare("INSERT INTO Users (name, email, phone) VALUES (?, ?, ?)");
    $query->bind_param('sss', $name, $email, $phone);
    
    if ($query->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $query->error]);
    }
}

function addAdmin($conn) {
    $data = json_decode(file_get_contents('php://input'), true);
    $full_name = $data['full_name'];
    $username = $data['username'];
    $email = $data['email'];
    $password = password_hash($data['password'], PASSWORD_BCRYPT);
    $phone = $data['phone'];
    $area = is_array($data['area']) ? implode(', ', $data['area']) : 'all';
    $registered_date = date('Y-m-d H:i:s');

    $query = $conn->prepare("INSERT INTO admins (full_name, username, email, password, phone, area, registered_date) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $query->bind_param('sssssss', $full_name, $username, $email, $password, $phone, $area, $registered_date);

    if ($query->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $query->error]);
    }
}

function editAdmin($conn) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'];
    $full_name = $data['full_name'];
    $username = $data['username'];
    $email = $data['email'];
    $phone = $data['phone'];
    $area = is_array($data['area']) ? implode(', ', $data['area']) : 'all';
    $password = !empty($data['password']) ? password_hash($data['password'], PASSWORD_BCRYPT) : null;

    $query_str = "UPDATE admins SET full_name=?, username=?, email=?, phone=?, area=?";
    if ($password) {
        $query_str .= ", password=?";
    }
    $query_str .= " WHERE id=?";
    
    $query = $conn->prepare($query_str);
    if ($password) {
        $query->bind_param('ssssssi', $full_name, $username, $email, $phone, $area, $password, $id);
    } else {
        $query->bind_param('sssssi', $full_name, $username, $email, $phone, $area, $id);
    }

    if ($query->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $query->error]);
    }
}

function deleteAdmin($conn) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'];

    $query = $conn->prepare("DELETE FROM admins WHERE id=?");
    $query->bind_param('i', $id);

    if ($query->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $query->error]);
    }
}

// Function for editing wallet information
function editWallet($conn) {
    $data = json_decode(file_get_contents('php://input'), true);
    $user_id = $data['user_id'];
    $balance = $data['balance'];
    $status = $data['status'];

    if (empty($user_id)) {
        echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
        return;
    }

    $query = $conn->prepare("UPDATE Wallet SET balance = ?, status = ? WHERE user_id = ?");
    $query->bind_param('dsi', $balance, $status, $user_id);

    if ($query->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Wallet updated successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => $query->error]);
    }
}
?>
