<?php
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php';  // Your database connection

// Retrieve the POST data
$action = isset($_POST['action']) ? mysqli_real_escape_string($conn, $_POST['action']) : null;
$user_id = isset($_POST['user_id']) ? mysqli_real_escape_string($conn, $_POST['user_id']) : null;
$balance = isset($_POST['balance']) ? mysqli_real_escape_string($conn, $_POST['balance']) : null;
$status = isset($_POST['status']) ? mysqli_real_escape_string($conn, $_POST['status']) : null;

// Check if action and user_id are provided
if (!$action || !$user_id) {
    echo json_encode(['error' => 'Action and user ID are required']);
    exit;
}

// Handle wallet update or creation based on the action
if ($action == 'edit_wallet') {
    $query = "UPDATE Wallet SET balance = '$balance', status = '$status' WHERE user_id = '$user_id'";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => 'Wallet updated successfully']);
    } else {
        echo json_encode(['error' => 'Failed to update wallet']);
    }
} elseif ($action == 'add_wallet') {
    $query = "INSERT INTO Wallet (user_id, balance, status) VALUES ('$user_id', '$balance', '$status')";
    if (mysqli_query($conn, $query)) {
        echo json_encode(['success' => 'Wallet added successfully']);
    } else {
        echo json_encode(['error' => 'Failed to add wallet']);
    }
} else {
    echo json_encode(['error' => 'Invalid action']);
}

mysqli_close($conn);


?>
