<?php
require_once __DIR__.'/../db.php';
$in = jpost();
$user_id = intval($in['user_id'] ?? 0);
$trip_id = intval($in['trip_id'] ?? 0);
$seat_count = max(1, min(6, intval($in['seat_count'] ?? 1)));
$name = trim($in['name'] ?? '');
$phone = trim($in['phone'] ?? '');
$notes = trim($in['notes'] ?? '');
$pay = trim($in['payment_method'] ?? 'cash');
if (!$trip_id) out(['ok'=>false,'error'=>'trip_id required']);

$trip = $mysqli->query("SELECT price FROM bus_trips WHERE id=$trip_id")->fetch_assoc();
if (!$trip) out(['ok'=>false,'error'=>'Trip not found']);
$amount = floatval($trip['price']) * $seat_count;

$code = strtoupper(bin2hex(random_bytes(3)));
$stmt = $mysqli->prepare("INSERT INTO bus_bookings (user_id, trip_id, seat_count, amount, payment_method, code, status, name, phone, notes)
VALUES (?,?,?,?,? ,?,'PENDING',?,?,?)");
$stmt->bind_param('iiidsssss', $user_id,$trip_id,$seat_count,$amount,$pay,$code,$name,$phone,$notes);
$stmt->execute();
out(['ok'=>true,'booking_id'=>$stmt->insert_id,'booking_code'=>$code,'amount'=>$amount]);
