<?php
// booking/my_bookings.php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
require_once '../db.php'; // provides $pdo (PDO)

// Ensure connection uses utf8mb4 (handles string literals like "➜", "•")
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($user_id <= 0) { echo json_encode(['ok'=>false,'error'=>'Missing user']); exit; }

try {
  // BUS
  $bus = $pdo->prepare("
    SELECT 
      CONCAT('BUS-', r.id) AS id,
      'bus' AS type,
      CONCAT(CONVERT(rt.from_city USING utf8mb4), ' ➜ ', CONVERT(rt.to_city USING utf8mb4)) AS title,
      CONCAT(COALESCE(CONVERT(o.name USING utf8mb4),'Unknown'), ' • ', CONVERT(t.bus_type USING utf8mb4)) AS subtitle,
      t.trip_date AS date,
      r.status AS status,
      r.amount AS amount,
      JSON_OBJECT(
        'seats',   r.seat_count,
        'depart',  t.depart_time,
        'arrive',  t.arrive_time,
        'pickup',  NULL
      ) AS meta
    FROM bus_bookings r
    JOIN bus_trips   t  ON t.id = r.trip_id
    JOIN bus_routes  rt ON rt.id = t.route_id
    LEFT JOIN bus_operators o ON o.id = t.operator_id
    WHERE r.user_id = ?
  ");
  $bus->execute([$user_id]);
  $busRows = $bus->fetchAll(PDO::FETCH_ASSOC);

  // SALON
  $salon = $pdo->prepare("
    SELECT 
      CONCAT('SAL-', a.id) AS id,
      'salon' AS type,
      CONVERT(s.name USING utf8mb4) AS title,
      CONVERT(sv.name USING utf8mb4) AS subtitle,
      a.date AS date,
      a.status AS status,
      a.amount AS amount,
      JSON_OBJECT(
        'service',  CONVERT(sv.name USING utf8mb4),
        'time',     a.time,
        'location', CONCAT_WS(', ',
                      CONVERT(s.address USING utf8mb4),
                      CONVERT(s.city USING utf8mb4)
                    )
      ) AS meta
    FROM salon_bookings a
    JOIN salon          s  ON s.id  = a.salon_id
    JOIN salon_services sv ON sv.id = a.service_id
    WHERE a.user_id = ?
  ");
  $salon->execute([$user_id]);
  $salonRows = $salon->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode(['ok'=>true,'bookings'=>array_merge($busRows, $salonRows)]);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'error'=>'Server error','detail'=>$e->getMessage()]);
}
