<?php
// common.php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/db.php';

function json_out($arr) {
  if (!headers_sent()) header('Content-Type: application/json; charset=utf-8');
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}

function read_json() {
  $raw = file_get_contents('php://input');
  if ($raw) { $j = json_decode($raw, true); if (is_array($j)) return $j; }
  return $_POST;
}

function is_lk($country_code) {
  $cc = strtoupper(trim((string)$country_code));
  return in_array($cc, ['LK','SRI LANKA','SRILANKA','LKA'], true);
}

/**
 * Normalize Sri Lankan mobile to strictly: 94XXXXXXXXX (digits only, no +)
 * Accepts: 0771234567, +94771234567, 0094771234567, 94771234567, 771234567
 */
function normalize_sl_phone($phone) {
  $d = preg_replace('/\D+/', '', (string)$phone);

  // 0XXXXXXXXX -> 94 + last 9
  if (preg_match('/^0\d{9}$/', $d)) return '94' . substr($d, 1);

  // 771234567 (9 digits) -> 94 + number
  if (preg_match('/^\d{9}$/', $d)) return '94' . $d;

  // 0094XXXXXXXXX -> 94XXXXXXXXX
  if (strpos($d, '0094') === 0 && strlen($d) >= 13) return substr($d, 2);

  // 94XXXXXXXXX (keep exactly 11 digits)
  if (preg_match('/^94\d{9}$/', $d)) return substr($d, 0, 11);

  // Fallback: trim to 11 if starts with 94 and longer
  if (strpos($d, '94') === 0 && strlen($d) > 11) return substr($d, 0, 11);

  // Last fallback: return digits as-is (for non-LK)
  return $d;
}

/** Convert to TextIt "to" number (digits only). For LK we enforce 94XXXXXXXXX. */
function to_textit_number($phone, $countryHint = 'LK') {
  if (is_lk($countryHint)) return normalize_sl_phone($phone);
  return preg_replace('/\D+/', '', (string)$phone);
}

/* ===== TextIt sendmsg creds =====
   Put real values in env OR here (avoid committing secrets) */
define('TEXTIT_USER', getenv('TEXTIT_USER') ?: '94752789219');
define('TEXTIT_PW',   getenv('TEXTIT_PW')   ?: '1789');

/** Send SMS via https://textit.biz/sendmsg */
function send_sms_via_textit($to, $message, $countryHint = 'LK') {
  if (!TEXTIT_USER || !TEXTIT_PW || TEXTIT_USER === '94123456789') {
    error_log('TextIt creds not configured (TEXTIT_USER/TEXTIT_PW).');
    return false;
  }

  $toNum = to_textit_number($to, $countryHint); // 94XXXXXXXXX
  if (!preg_match('/^94\d{9}$/', $toNum)) {
    error_log('TextIt invalid destination: ' . $toNum);
    return false;
  }

  $baseurl = 'https://textit.biz/sendmsg';
  $qs = http_build_query([
    'id'   => TEXTIT_USER,
    'pw'   => TEXTIT_PW,
    'to'   => $toNum,
    'text' => $message,
  ]);
  $url = $baseurl . '/?' . $qs;

  $line = null;

  // Try file(), fallback to cURL
  if (filter_var(ini_get('allow_url_fopen'), FILTER_VALIDATE_BOOLEAN)) {
    $resp = @file($url);
    if ($resp && isset($resp[0])) $line = trim($resp[0]);
  } else {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_TIMEOUT => 20,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_SSL_VERIFYPEER => true,
    ]);
    $body = curl_exec($ch);
    $err  = curl_error($ch);
    curl_close($ch);
    if ($err) error_log('TextIt CURL error: '.$err);
    if ($body) $line = trim(strtok($body, "\r\n"));
  }

  if (!$line) { error_log('TextIt no response'); return false; }

  // Expect "OK: <id>" or "ERROR: <reason>"
  $parts = explode(':', $line, 2);
  $status = strtoupper(trim($parts[0] ?? ''));
  return ($status === 'OK');
}

/** Generate numeric OTP */
function generate_otp($len=6) {
  $min = (int)pow(10, $len-1);
  $max = (int)pow(10, $len) - 1;
  return (string)random_int($min, $max);
}
