<?php
// geocode.php
require_once __DIR__ . '/common.php';

define('GMAPS_KEY', getenv('GOOGLE_MAPS_KEY') ?: 'AIzaSyB2-q_0T2LB2sA1X_syazc4Y-yZ-IdmSvo');
if (!GMAPS_KEY) json_out(['ok'=>false,'error'=>'Geocoder not configured']);

$in = read_json();
$q = trim((string)($in['query'] ?? ''));
if ($q === '') json_out(['ok'=>false,'error'=>'Empty query']);

try {
  $url = 'https://maps.googleapis.com/maps/api/geocode/json?' . http_build_query([
    'address' => $q,
    'region'  => 'lk',        // bias to Sri Lanka (adjust as needed)
    'key'     => GMAPS_KEY
  ]);

  $ch = curl_init($url);
  curl_setopt_array($ch, [ CURLOPT_RETURNTRANSFER=>true, CURLOPT_TIMEOUT=>15 ]);
  $body = curl_exec($ch);
  curl_close($ch);

  $j = json_decode($body, true);
  if (!is_array($j) || ($j['status'] ?? '') !== 'OK') {
    json_out(['ok'=>false,'error'=>'No results']);
  }
  $r0 = $j['results'][0];
  $loc = $r0['geometry']['location'];
  json_out([
    'ok'=>true,
    'result'=>[
      'lat' => $loc['lat'],
      'lng' => $loc['lng'],
      'formatted' => $r0['formatted_address'] ?? $q
    ]
  ]);
} catch (Throwable $e) {
  error_log('geocode error: '.$e->getMessage());
  json_out(['ok'=>false,'error'=>'Server error']);
}
