<?php
require_once __DIR__ . '/common.php';
define('GMAPS_KEY', getenv('GOOGLE_MAPS_KEY') ?: 'AIzaSyB2-q_0T2LB2sA1X_syazc4Y-yZ-IdmSvo');
if (!GMAPS_KEY) json_out(['ok'=>false,'error'=>'GMAPS key missing']);

$in = read_json();
$pid = trim((string)($in['place_id'] ?? ''));
if ($pid === '') json_out(['ok'=>false,'error'=>'place_id required']);

try {
  $url = 'https://maps.googleapis.com/maps/api/place/details/json?' . http_build_query([
    'place_id' => $pid,
    'fields'   => 'geometry,address_component,formatted_address',
    'key'      => GMAPS_KEY
  ]);

  $body = file_get_contents($url);
  $j = json_decode($body, true);
  if (!is_array($j) || ($j['status'] ?? '') !== 'OK') json_out(['ok'=>false,'error'=>'No details']);

  $res = $j['result'] ?? [];
  $loc = $res['geometry']['location'] ?? null;
  if (!$loc) json_out(['ok'=>false,'error'=>'No geometry']);

  $city = '';
  foreach (($res['address_components'] ?? []) as $c) {
    $types = $c['types'] ?? [];
    if (in_array('locality', $types, true) || in_array('administrative_area_level_2', $types, true)) {
      $city = $c['long_name']; break;
    }
    if (in_array('sublocality', $types, true) && !$city) $city = $c['long_name'];
  }

  json_out(['ok'=>true, 'result'=>[
    'lat' => (float)$loc['lat'],
    'lng' => (float)$loc['lng'],
    'formatted' => $res['formatted_address'] ?? '',
    'city' => $city
  ]]);
} catch (Throwable $e) {
  error_log('geocode_place: '.$e->getMessage());
  json_out(['ok'=>false,'error'=>'Server error']);
}
