<?php
// login_request_otp.php
require_once __DIR__ . '/common.php';

if (!headers_sent()) header('Content-Type: application/json; charset=utf-8');

$in       = read_json();
$country  = strtoupper(trim((string)($in['country'] ?? 'LK')));
$phone_in = trim((string)($in['phone'] ?? ''));

// Use strictly 94XXXXXXXXX for LK
$phone = is_lk($country) ? normalize_sl_phone($phone_in) : preg_replace('/\D+/', '', $phone_in);
if ($phone === '' || (is_lk($country) && !preg_match('/^94\d{9}$/', $phone))) {
  json_out(['ok'=>false, 'error'=>'Invalid phone number']);
}

try {
  // Look up user by phone
  $q = $pdo->prepare("SELECT id, email, name, country_code FROM users WHERE phone = ? LIMIT 1");
  $q->execute([$phone]);
  $u = $q->fetch();

  if (!$u) {
    json_out(['ok'=>false, 'not_found'=>true, 'error'=>'No account with this phone']);
  }

  // Rate-limit: last OTP younger than 30s? deny
  $recent = $pdo->prepare("SELECT id, created_at FROM otp_codes WHERE phone=? AND purpose='login' ORDER BY id DESC LIMIT 1");
  $recent->execute([$phone]);
  $last = $recent->fetch();
  if ($last && (time() - strtotime($last['created_at'])) < 30) {
    json_out(['ok'=>false, 'error'=>'Please wait a moment before requesting another code.']);
  }

  // Generate + store OTP (valid 10 mins)
  $code = generate_otp(6);
  $exp  = date('Y-m-d H:i:s', time() + 600);
  $ins  = $pdo->prepare("INSERT INTO otp_codes (user_id, phone, code, purpose, expires_at, attempts, is_used, created_at)
                         VALUES (?, ?, ?, 'login', ?, 0, 0, NOW())");
  $ins->execute([(int)$u['id'], $phone, $code, $exp]);

  // Send SMS (best-effort)
  @send_sms_via_textit($phone, "Your BayEx login code is {$code}", 'LK');

  // In dev, let the client see it for console.log
  $debugFlag = isset($_GET['debug_otp']) && $_GET['debug_otp'] === '1';
  $out = ['ok'=>true];
  if ($debugFlag) $out['debug_otp'] = $code;

  json_out($out);

} catch (Throwable $e) {
  error_log('login_request_otp error: '.$e->getMessage());
  json_out(['ok'=>false, 'error'=>'Server error']);
}
