<?php
require_once __DIR__ . '/common.php';
define('GMAPS_KEY', getenv('GOOGLE_MAPS_KEY') ?: 'AIzaSyB2-q_0T2LB2sA1X_syazc4Y-yZ-IdmSvo');
if (!GMAPS_KEY) json_out(['ok'=>false,'error'=>'GMAPS key missing']);

$in = read_json();
$q = trim((string)($in['query'] ?? ''));
if ($q === '' || strlen($q) < 3) json_out(['ok'=>true, 'results'=>[]]);

try {
  // Places Autocomplete
  $url = 'https://maps.googleapis.com/maps/api/place/autocomplete/json?' . http_build_query([
    'input'  => $q,
    'types'  => 'geocode',
    'components' => 'country:lk',  // bias to Sri Lanka
    'key'    => GMAPS_KEY
  ]);

  $body = file_get_contents($url);
  $j = json_decode($body, true);
  if (!is_array($j) || ($j['status'] ?? '') !== 'OK') json_out(['ok'=>true,'results'=>[]]);

  $out = [];
  foreach (($j['predictions'] ?? []) as $p) {
    $desc = $p['description'] ?? '';
    $city = '';
    // Quick city guess from structured formatting
    if (isset($p['structured_formatting']['secondary_text'])) {
      $city = $p['structured_formatting']['secondary_text'];
    }
    $out[] = [ 'id' => $p['place_id'], 'description' => $desc, 'city' => $city ];
  }
  json_out(['ok'=>true, 'results'=>$out]);
} catch (Throwable $e) {
  error_log('geocode_suggest: '.$e->getMessage());
  json_out(['ok'=>true,'results'=>[]]); // fail-soft
}
