<?php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;
if (!$store_id) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'store_id required']); exit; }

try {
  $sql = "SELECT c.id, c.name, c.sort_order, c.is_active,
                 COUNT(m.product_id) AS product_count
          FROM product_categories c
          LEFT JOIN product_category_map m ON m.category_id=c.id
          LEFT JOIN products p ON p.id = m.product_id AND p.is_active=1
          WHERE c.store_id=? AND c.is_active=1
          GROUP BY c.id
          ORDER BY c.sort_order ASC, c.id ASC";
  $st = $pdo->prepare($sql);
  $st->execute([$store_id]);
  echo json_encode(['ok'=>true,'categories'=>$st->fetchAll()]);
} catch (Exception $e) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'Query failed']); }
