<?php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;
if (!$store_id) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'store_id required']); exit; }

try {
  $s = $pdo->prepare("SELECT * FROM stores WHERE id=? AND is_active=1 LIMIT 1");
  $s->execute([$store_id]);
  $store = $s->fetch();
  if (!$store) { http_response_code(404); echo json_encode(['ok'=>false,'error'=>'Store not found']); exit; }

  echo json_encode(['ok'=>true,'store'=>$store]);
} catch (Exception $e) {
  http_response_code(500); echo json_encode(['ok'=>false,'error'=>'Query failed']);
}
