<?php
require_once 'db.php'; // Adjust the path as necessary

header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, access");
header("Access-Control-Allow-Credentials: true");

$response = array();

try {
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        // Fetch all drivers who are approved and have current latitude and longitude set
        $stmt = $conn->prepare("SELECT *,id, driver_name, phone, vehicle_number, vehicle_current_lat AS latitude, vehicle_current_lng AS longitude FROM registered_vehicles WHERE  vehicle_current_lat IS NOT NULL AND vehicle_current_lng IS NOT NULL");
        $stmt->execute();
        $result = $stmt->get_result();

        $drivers = array();
        while ($row = $result->fetch_assoc()) {
            $drivers[] = $row;
        }

        $response = $drivers;
    } else {
        http_response_code(405); // Method Not Allowed
        $response['error'] = 'Method not allowed';
    }
} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>
