<?php
include 'db.php';  // Include your database connection file

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $booking_id = $_GET['booking_id'];

    if (!$booking_id) {
        echo json_encode(['success' => false, 'message' => 'Booking ID is required']);
        exit();
    }

    $stmt = $conn->prepare("SELECT status, driver FROM new_trip_booking WHERE id = ?");
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Error in prepare statement: ' . $conn->error]);
        exit();
    }

    $stmt->bind_param('i', $booking_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $booking = $result->fetch_assoc();

    if ($booking) {
        echo json_encode(['success' => true, 'status' => $booking['status'], 'driver_id' => $booking['driver']]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Booking not found']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}

$conn->close();
?>
