<?php
include 'db.php';  // Include your database connection file

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $driver_id = $_GET['driver_id'];

    if (!$driver_id) {
        echo json_encode(['success' => false, 'message' => 'Driver ID is required']);
        exit();
    }

    $stmt = $conn->prepare("SELECT * FROM registered_vehicles WHERE id = ?");
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Error in prepare statement: ' . $conn->error]);
        exit();
    }

    $stmt->bind_param('i', $driver_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $driver = $result->fetch_assoc();

    if ($driver) {
        echo json_encode(['success' => true, 'driver' => $driver]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Driver not found']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}

$conn->close();
?>
