<?php
header('Content-Type: application/json');
require 'db.php'; // Database connection details

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $userId = $_GET['userId'];

    if (empty($userId)) {
        echo json_encode(['error' => 'User ID is required']);
        exit;
    }

    $query = "SELECT id, name, phone, email, location, address, profile_picture, referral_code, refered_code FROM users WHERE id = ?";
    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            echo json_encode($user);
        } else {
            echo json_encode(['error' => 'User not found']);
        }

        $stmt->close();
    } else {
        echo json_encode(['error' => 'Failed to prepare statement']);
    }
} else {
    echo json_encode(['error' => 'Invalid request method']);
}

$conn->close();
?>
