<?php
require_once __DIR__.'/../db.php';
$code = trim($_GET['code'] ?? '');
if (!$code) out(['ok'=>false,'error'=>'code required']);

$stmt = $mysqli->prepare("SELECT id, trip_id, seat_count, amount, status, code, created_at FROM bus_bookings WHERE code=? LIMIT 1");
$stmt->bind_param('s',$code);
$stmt->execute();
$bk = $stmt->get_result()->fetch_assoc();
if (!$bk) out(['ok'=>false,'error'=>'Not found']);

$seats = [];
if (in_array($bk['status'], ['CONFIRMED','PAID'])) {
  $res = $mysqli->query("SELECT seat_label FROM bus_booking_seats WHERE booking_id=".$bk['id']." ORDER BY seat_label asc");
  while ($x = $res->fetch_row()) $seats[] = $x[0];
}
out(['ok'=>true, 'booking'=>[
  'id'=>intval($bk['id']),
  'trip_id'=>intval($bk['trip_id']),
  'status'=>$bk['status'],
  'amount'=>floatval($bk['amount']),
  'seat_count'=>intval($bk['seat_count']),
  'code'=>$bk['code'],
  'created_at'=>$bk['created_at'],
  'seats'=>$seats
]]);
