<?php
// login_password.php
require_once __DIR__ . '/common.php';

if (!headers_sent()) header('Content-Type: application/json; charset=utf-8');

$in       = read_json();
$email    = strtolower(trim((string)($in['email']    ?? '')));
$password = (string)($in['password'] ?? '');

if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
  json_out(['ok'=>false, 'error'=>'Valid email required']);
}
if ($password === '') {
  json_out(['ok'=>false, 'error'=>'Password required']);
}

try {
  $q = $pdo->prepare("SELECT id, name, email, phone, country_code, password_hash FROM users WHERE LOWER(email)=? LIMIT 1");
  $q->execute([$email]);
  $u = $q->fetch();

  if (!$u || !password_verify($password, (string)$u['password_hash'])) {
    json_out(['ok'=>false, 'error'=>'Invalid credentials']);
  }

  unset($u['password_hash']);
  json_out(['ok'=>true, 'user'=>$u, 'user_id'=>(int)$u['id']]);

} catch (Throwable $e) {
  error_log('login_password error: '.$e->getMessage());
  json_out(['ok'=>false, 'error'=>'Server error']);
}
