<?php
// login_verify_otp.php
require_once __DIR__ . '/common.php';

if (!headers_sent()) header('Content-Type: application/json; charset=utf-8');

$in       = read_json();
$country  = strtoupper(trim((string)($in['country'] ?? 'LK')));
$phone_in = trim((string)($in['phone'] ?? ''));
$code_in  = trim((string)($in['code']  ?? ''));

$phone = is_lk($country) ? normalize_sl_phone($phone_in) : preg_replace('/\D+/', '', $phone_in);

if (!preg_match('/^\d{4,8}$/', $code_in)) {
  json_out(['ok'=>false, 'error'=>'Invalid code']);
}

try {
  // Find an unused, unexpired OTP for this phone
  $q = $pdo->prepare("
    SELECT * FROM otp_codes
    WHERE phone=? AND purpose='login' AND is_used=0 AND expires_at > NOW()
    ORDER BY id DESC LIMIT 1
  ");
  $q->execute([$phone]);
  $otp = $q->fetch();

  if (!$otp) json_out(['ok'=>false, 'error'=>'Code expired or not found']);

  // Bump attempts; block if too many
  $tries = (int)$otp['attempts'] + 1;
  if ($tries > 6) {
    $upd = $pdo->prepare("UPDATE otp_codes SET attempts=?, is_used=1 WHERE id=?");
    $upd->execute([$tries, (int)$otp['id']]);
    json_out(['ok'=>false, 'error'=>'Too many attempts. Request a new code.']);
  }

  if ($otp['code'] !== $code_in) {
    $upd = $pdo->prepare("UPDATE otp_codes SET attempts=? WHERE id=?");
    $upd->execute([$tries, (int)$otp['id']]);
    json_out(['ok'=>false, 'error'=>'Invalid code']);
  }

  // Valid → mark used
  $upd = $pdo->prepare("UPDATE otp_codes SET is_used=1, attempts=? WHERE id=?");
  $upd->execute([$tries, (int)$otp['id']]);

  // Return user object
  $u = $pdo->prepare("SELECT id, name, email, phone, country_code FROM users WHERE id=? LIMIT 1");
  $u->execute([(int)$otp['user_id']]);
  $user = $u->fetch();

  if (!$user) json_out(['ok'=>false, 'error'=>'User not found']);

  // Optionally mark phone verified
  $pdo->prepare("UPDATE users SET phone_verified_at = NOW() WHERE id=? AND phone_verified_at IS NULL")
      ->execute([(int)$user['id']]);

  json_out(['ok'=>true, 'user'=>$user, 'user_id'=>(int)$user['id']]);

} catch (Throwable $e) {
  error_log('login_verify_otp error: '.$e->getMessage());
  json_out(['ok'=>false, 'error'=>'Server error']);
}
