<?php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
if (!$product_id) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'product_id required']); exit; }

try {
  $p = $pdo->prepare("SELECT id, store_id, name, description, base_price, promo_price, has_variants, in_stock, image_url FROM products WHERE id=? AND is_active=1 LIMIT 1");
  $p->execute([$product_id]);
  $product = $p->fetch();
  if (!$product) { http_response_code(404); echo json_encode(['ok'=>false,'error'=>'Product not found']); exit; }

  $v = $pdo->prepare("SELECT id, name, price, in_stock FROM product_variants WHERE product_id=? ORDER BY sort_order ASC, id ASC");
  $v->execute([$product_id]);
  $variants = $v->fetchAll();

  $g = $pdo->prepare("SELECT id, name, min_select, max_select, required FROM modifier_groups WHERE product_id=? ORDER BY sort_order ASC, id ASC");
  $g->execute([$product_id]);
  $groups = $g->fetchAll();

  foreach ($groups as &$grp) {
    $m = $pdo->prepare("SELECT id, name, price FROM modifiers WHERE group_id=? ORDER BY sort_order ASC, id ASC");
    $m->execute([$grp['id']]);
    $grp['modifiers'] = $m->fetchAll();
  }

  echo json_encode(['ok'=>true,'product'=>$product,'variants'=>$variants,'modifier_groups'=>$groups], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'Query failed']); }
