<?php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;
if (!$store_id) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'store_id required']); exit; }

$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;
$min_price = isset($_GET['min_price']) ? floatval($_GET['min_price']) : null;
$max_price = isset($_GET['max_price']) ? floatval($_GET['max_price']) : null;
$in_stock = isset($_GET['in_stock']) ? intval($_GET['in_stock']) : null;
$has_variants = isset($_GET['has_variants']) ? intval($_GET['has_variants']) : null;
$tags = isset($_GET['tags']) ? trim($_GET['tags']) : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'popular';

$page = max(1, isset($_GET['page']) ? intval($_GET['page']) : 1);
$per_page = max(1, min(50, isset($_GET['per_page']) ? intval($_GET['per_page']) : 20));
$offset = ($page - 1) * $per_page;

$w = ["p.store_id = ?","p.is_active=1"];
$params = [$store_id];

if ($search !== '') { $w[] = "p.name LIKE ?"; $params[] = "%$search%"; }
if ($category_id) {
  $w[] = "EXISTS (SELECT 1 FROM product_category_map m WHERE m.product_id=p.id AND m.category_id=?)";
  $params[] = $category_id;
}
if ($in_stock !== null) { $w[] = "p.in_stock = ?"; $params[] = $in_stock; }
if ($has_variants !== null) { $w[] = "p.has_variants = ?"; $params[] = $has_variants; }
if ($min_price !== null) { $w[] = "(p.base_price >= ? OR EXISTS(SELECT 1 FROM product_variants v WHERE v.product_id=p.id AND v.price >= ?))"; $params[] = $min_price; $params[] = $min_price; }
if ($max_price !== null) { $w[] = "(p.base_price <= ? OR EXISTS(SELECT 1 FROM product_variants v2 WHERE v2.product_id=p.id AND v2.price <= ?))"; $params[] = $max_price; $params[] = $max_price; }
if ($tags !== '') {
  // tags comma list, e.g., vegan,spicy
  $tagList = array_filter(array_map('trim', explode(',', $tags)));
  if (count($tagList) > 0) {
    $tagClauses = [];
    foreach ($tagList as $tg) {
      $tagClauses[] = "FIND_IN_SET(?, p.tags)";
      $params[] = $tg;
    }
    $w[] = '(' . implode(' OR ', $tagClauses) . ')';
  }
}

$order = "p.rating_count DESC, p.rating_avg DESC";
if ($sort === 'price_asc') $order = "COALESCE(NULLIF(p.promo_price,0), NULLIF(p.base_price,0), (SELECT MIN(v.price) FROM product_variants v WHERE v.product_id=p.id)) ASC";
if ($sort === 'price_desc') $order = "COALESCE(NULLIF(p.promo_price,0), NULLIF(p.base_price,0), (SELECT MIN(v.price) FROM product_variants v WHERE v.product_id=p.id)) DESC";
if ($sort === 'rating_desc') $order = "p.rating_avg DESC, p.rating_count DESC";

$where = implode(' AND ', $w);

$sql = "SELECT p.id, p.name, p.description, p.base_price, p.promo_price, p.has_variants,
               p.in_stock, p.rating_avg, p.rating_count, p.image_url, p.tags
        FROM products p
        WHERE $where
        ORDER BY $order
        LIMIT $per_page OFFSET $offset";

try {
  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);
  $rows = $stmt->fetchAll();

  echo json_encode(['ok'=>true,'products'=>$rows,'page'=>$page,'per_page'=>$per_page], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'Query failed']); }
