<?php
// /new_api/stores_categories.php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

// Allowed service types in your SET column:
$services = ['food','grocery','retail'];
$out = [];

try {
  foreach ($services as $srv) {
    $stmt = $pdo->prepare(
      "SELECT COUNT(*) AS c FROM stores
       WHERE is_active=1 AND FIND_IN_SET(?, service_types)"
    );
    $stmt->execute([$srv]);
    $row = $stmt->fetch();
    if (($row['c'] ?? 0) > 0) {
      $out[] = ['slug'=>$srv, 'name'=>ucfirst($srv), 'count'=>(int)$row['c']];
    }
  }
  echo json_encode(['ok'=>true, 'categories'=>$out], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'Query failed']);
}
