<?php
// /new_api/stores_featured.php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$service = isset($_GET['service']) ? strtolower(trim($_GET['service'])) : '';
$lat = isset($_GET['lat']) ? floatval($_GET['lat']) : 0;
$lng = isset($_GET['lng']) ? floatval($_GET['lng']) : 0;
$limit = isset($_GET['limit']) ? max(1, min(50, intval($_GET['limit']))) : 10;

$params = [];
$distanceSql = '';
$orderDistance = '';

if ($lat !== 0 && $lng !== 0) {
  // Haversine (km), protect with LEAST(1, ..) to avoid NaN from rounding
  $distanceSql = " , (6371 * ACOS(LEAST(1,
                  COS(RADIANS(?)) * COS(RADIANS(lat)) * COS(RADIANS(lng) - RADIANS(?)) +
                  SIN(RADIANS(?)) * SIN(RADIANS(lat))
                ))) AS distance_km ";
  $params[] = $lat; $params[] = $lng; $params[] = $lat;
  $orderDistance = " , distance_km ASC ";
}

$where = " WHERE s.is_active=1 AND s.is_sponsored=1 ";
if (in_array($service, ['food','grocery','retail'], true)) {
  $where .= " AND FIND_IN_SET(?, s.service_types) ";
  $params[] = $service;
}

$sql = "SELECT s.id, s.name, s.description, s.service_types, s.rating_avg, s.rating_count,
               s.min_order, s.delivery_fee, s.eta_min, s.eta_max, s.city, s.lat, s.lng,
               s.logo_url, s.cover_url, s.is_open, s.is_sponsored, s.sponsored_rank
               $distanceSql
        FROM stores s
        $where
        ORDER BY s.sponsored_rank ASC $orderDistance, s.rating_avg DESC
        LIMIT $limit";

try {
  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);
  $rows = $stmt->fetchAll();

  echo json_encode(['ok'=>true, 'stores'=>$rows], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>'Query failed']);
}
