<?php
// /new_api/stores_locations.php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$service = isset($_GET['service']) ? strtolower(trim($_GET['service'])) : '';
$lat = isset($_GET['lat']) ? floatval($_GET['lat']) : null;
$lng = isset($_GET['lng']) ? floatval($_GET['lng']) : null;

if (!in_array($service, ['food','grocery','retail'], true)) {
  http_response_code(422);
  echo json_encode(['ok'=>false,'error'=>'service required (food|grocery|retail)']);
  exit;
}

$params = [$service];
$distanceSql = '';
$order = 'l.city ASC';

if ($lat !== null && $lng !== null) {
  $distanceSql = " , MIN(6371 * ACOS(LEAST(1,
                   COS(RADIANS(?)) * COS(RADIANS(s.lat)) * COS(RADIANS(s.lng) - RADIANS(?)) +
                   SIN(RADIANS(?)) * SIN(RADIANS(s.lat))
                 ))) AS distance_km ";
  $params = [$service, $lat, $lng, $lat];
  $order = 'distance_km ASC, l.city ASC';
}

$sql = "SELECT l.city,
               COUNT(*) AS store_count
               $distanceSql
        FROM stores s
        JOIN (SELECT DISTINCT city FROM stores WHERE city IS NOT NULL AND city <> '') l
          ON l.city = s.city
        WHERE s.is_active=1
          AND FIND_IN_SET(?, s.service_types)
          AND s.city IS NOT NULL AND s.city <> ''
        GROUP BY l.city
        ORDER BY $order";

try {
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll();
  echo json_encode(['ok'=>true, 'locations'=>$rows], JSON_UNESCAPED_SLASHES);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>'Query failed']);
}
